# نظام إدارة عيادة الأسنان المتكامل
## Dental Clinic Management System

---

## نظرة عامة | Overview

نظام إدارة عيادة أسنان متكامل مطور باستخدام PHP 8.1 و MySQL مع واجهة Bootstrap متجاوبة. يدعم اللغتين العربية والإنجليزية ويتضمن جميع الميزات اللازمة لإدارة عيادة أسنان حديثة.

---

## المتطلبات | Requirements

### متطلبات الخادم | Server Requirements
- **PHP**: 8.0 أو أحدث
- **MySQL**: 5.7 أو أحدث  
- **Apache**: 2.4 أو أحدث
- **مساحة التخزين**: 100 ميجابايت على الأقل

### الإضافات المطلوبة | Required Extensions
- php-mysql
- php-mbstring
- php-xml
- php-curl
- php-zip
- php-gd

---

## التثبيت | Installation

### 1. رفع الملفات | Upload Files
```bash
# رفع جميع ملفات النظام إلى مجلد الخادم
# Upload all system files to server directory
cp -r dental_clinic_system/ /var/www/html/
```

### 2. إعداد قاعدة البيانات | Database Setup
```sql
-- إنشاء قاعدة البيانات
CREATE DATABASE dental_clinic_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- إنشاء مستخدم قاعدة البيانات
CREATE USER 'dental_user'@'localhost' IDENTIFIED BY 'dental_pass_2024';
GRANT ALL PRIVILEGES ON dental_clinic_db.* TO 'dental_user'@'localhost';
FLUSH PRIVILEGES;
```

### 3. تشغيل ملفات SQL | Run SQL Files
```bash
# تشغيل ملف إنشاء الجداول
mysql -u dental_user -p dental_clinic_db < config/database_schema_fixed.sql

# تشغيل ملف البيانات الأولية
mysql -u dental_user -p dental_clinic_db < config/initial_data_minimal.sql
```

### 4. إعداد الصلاحيات | Set Permissions
```bash
# إعداد صلاحيات الملفات
chown -R www-data:www-data /var/www/html/dental_clinic_system/
chmod -R 755 /var/www/html/dental_clinic_system/
chmod -R 777 /var/www/html/dental_clinic_system/uploads/
chmod -R 777 /var/www/html/dental_clinic_system/backups/
chmod -R 777 /var/www/html/dental_clinic_system/logs/
```

### 5. تعديل إعدادات قاعدة البيانات | Configure Database
```php
// تعديل ملف config/database.php
define('DB_HOST', 'localhost');
define('DB_NAME', 'dental_clinic_db');
define('DB_USER', 'dental_user');
define('DB_PASS', 'dental_pass_2024');
```

---

## بيانات الدخول الافتراضية | Default Login Credentials

### المدير | Administrator
- **اسم المستخدم**: admin
- **كلمة المرور**: admin123
- **البريد الإلكتروني**: admin@dentalclinic.com

### الطبيب | Doctor  
- **اسم المستخدم**: doctor
- **كلمة المرور**: admin123
- **البريد الإلكتروني**: doctor@dentalclinic.com

### موظف الاستقبال | Receptionist
- **اسم المستخدم**: receptionist
- **كلمة المرور**: admin123
- **البريد الإلكتروني**: receptionist@dentalclinic.com

---

## الميزات | Features

### ✅ إدارة المستخدمين | User Management
- تسجيل الدخول والخروج
- إدارة أنواع المستخدمين
- تغيير كلمات المرور
- نظام صلاحيات متقدم

### ✅ إدارة الموظفين | Staff Management
- إضافة وتعديل الموظفين
- إدارة المعلومات الشخصية
- تتبع الرواتب والمؤهلات

### ✅ إدارة المرضى | Patient Management
- ملفات طبية شاملة
- تاريخ مرضي مفصل
- معلومات الاتصال والطوارئ
- إدارة التأمين الطبي

### ✅ إدارة الإجراءات | Procedure Management
- جميع أنواع علاجات الأسنان
- تتبع التكاليف والرسوم
- إدارة الأسنان المعالجة
- حساب المجاميع والمستحقات

### ✅ إدارة الفواتير | Invoice Management
- إنشاء فواتير احترافية
- حساب الضرائب والخصومات
- تتبع المدفوعات
- طباعة الفواتير

### ✅ التقارير | Reports
- تقارير مالية شاملة
- تقارير الإجراءات
- تقارير المرضى والموظفين
- تقارير حسب التاريخ

### ✅ النسخ الاحتياطي | Backup System
- نسخ احتياطية آمنة
- استعادة البيانات
- جدولة النسخ التلقائية

### ✅ نظام الإشعارات | Notification System
- إشعارات فورية
- دعم متعدد اللغات
- تنبيهات المواعيد

---

## الأمان | Security

### 🔒 حماية البيانات
- تشفير كلمات المرور
- حماية من SQL Injection
- حماية من XSS
- نظام جلسات آمن

### 🔒 حماية الملفات
- ملف .htaccess للأمان
- منع الوصول للملفات الحساسة
- تسجيل الأنشطة

---

## الدعم | Support

### 📧 التواصل
- البريد الإلكتروني: support@dentalclinic.com
- الهاتف: +966501234567

### 📚 التوثيق
- دليل المستخدم
- دليل المطور
- دليل استكشاف الأخطاء

---

## الترخيص | License

هذا النظام مطور خصيصاً لإدارة عيادات الأسنان ويمكن استخدامه وتعديله حسب الحاجة.

---

## الإصدار | Version

**الإصدار**: 1.0.0  
**تاريخ الإصدار**: 8 يوليو 2025  
**المطور**: نظام Manus AI  

---

## ملاحظات مهمة | Important Notes

1. **تغيير كلمات المرور**: يُنصح بتغيير كلمات المرور الافتراضية فور التثبيت
2. **النسخ الاحتياطية**: قم بإعداد نسخ احتياطية دورية لحماية البيانات
3. **التحديثات**: تابع التحديثات الأمنية للنظام
4. **الدعم الفني**: تواصل معنا للحصول على الدعم الفني

---

**مرحباً بك في نظام إدارة عيادة الأسنان المتكامل!**  
**Welcome to the Comprehensive Dental Clinic Management System!**

