<?php
/**
 * إعدادات قاعدة البيانات - نظام إدارة عيادة الأسنان
 * Database Configuration - Dental Clinic Management System
 */

// إعدادات قاعدة البيانات
define('DB_HOST', 'localhost');
define('DB_NAME', 'dental_clinic_db');
define('DB_USER', 'dental_user');
define('DB_PASS', 'dental_pass_2024');
define('DB_CHARSET', 'utf8mb4');

// إعدادات النظام العامة
define('SITE_NAME', 'نظام إدارة عيادة الأسنان');
define('SITE_NAME_EN', 'Dental Clinic Management System');
define('SITE_VERSION', '1.0.0');
define('SITE_URL', 'http://localhost/dental_clinic_system');

// إعدادات الأمان
define('SESSION_TIMEOUT', 3600); // ساعة واحدة
define('PASSWORD_MIN_LENGTH', 8);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 دقيقة

// إعدادات الملفات
define('UPLOAD_PATH', __DIR__ . '/../uploads/');
define('BACKUP_PATH', __DIR__ . '/../backups/');
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5 ميجابايت

// إعدادات اللغة
define('DEFAULT_LANGUAGE', 'ar');
define('SUPPORTED_LANGUAGES', ['ar', 'en']);

// إعدادات التاريخ والوقت
date_default_timezone_set('Asia/Riyadh');
define('DATE_FORMAT', 'Y-m-d');
define('DATETIME_FORMAT', 'Y-m-d H:i:s');
define('DISPLAY_DATE_FORMAT', 'd/m/Y');
define('DISPLAY_DATETIME_FORMAT', 'd/m/Y H:i');

// إعدادات العرض
define('RECORDS_PER_PAGE', 20);
define('MAX_SEARCH_RESULTS', 100);

// إعدادات البريد الإلكتروني (للإشعارات المستقبلية)
define('SMTP_HOST', '');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', '');
define('SMTP_PASSWORD', '');
define('SMTP_ENCRYPTION', 'tls');

// إعدادات النسخ الاحتياطي
define('AUTO_BACKUP_ENABLED', true);
define('BACKUP_RETENTION_DAYS', 30);
define('BACKUP_SCHEDULE', 'daily'); // daily, weekly, monthly

// إعدادات التطوير
define('DEBUG_MODE', true);
define('ERROR_REPORTING_LEVEL', E_ALL);
define('LOG_ERRORS', true);
define('ERROR_LOG_PATH', __DIR__ . '/../logs/error.log');

// إنشاء مجلدات ضرورية إذا لم تكن موجودة
$required_dirs = [
    UPLOAD_PATH,
    BACKUP_PATH,
    dirname(ERROR_LOG_PATH)
];

foreach ($required_dirs as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
}
?>

