-- البيانات الأولية لنظام إدارة عيادة الأسنان (النهائي)
-- Initial Data for Dental Clinic Management System (Final)

-- إدراج المستخدم المدير الافتراضي
-- Default admin user (username: admin, password: admin123)
INSERT INTO users (username, email, password_hash, user_type, first_name, last_name, is_active, created_at) VALUES
('admin', 'admin@dentalclinic.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'مدير', 'النظام', 1, NOW());

-- إدراج أنواع الإجراءات الأساسية
INSERT INTO procedure_types (type_name, type_name_ar, default_cost, description, description_ar, is_active) VALUES
('Consultation', 'استشارة', 100.00, 'General dental consultation', 'استشارة أسنان عامة', 1),
('Cleaning', 'تنظيف', 150.00, 'Professional teeth cleaning', 'تنظيف أسنان احترافي', 1),
('Filling', 'حشو', 200.00, 'Dental filling', 'حشو أسنان', 1),
('Extraction', 'خلع', 250.00, 'Tooth extraction', 'خلع سن', 1),
('Root Canal', 'علاج عصب', 800.00, 'Root canal treatment', 'علاج عصب السن', 1),
('Crown', 'تاج', 1200.00, 'Dental crown', 'تاج سن', 1),
('Bridge', 'جسر', 2000.00, 'Dental bridge', 'جسر أسنان', 1),
('Implant', 'زراعة', 3000.00, 'Dental implant', 'زراعة سن', 1),
('Orthodontics', 'تقويم', 5000.00, 'Orthodontic treatment', 'علاج تقويم الأسنان', 1),
('Whitening', 'تبييض', 500.00, 'Teeth whitening', 'تبييض الأسنان', 1);

-- إدراج إعدادات النظام الافتراضية
INSERT INTO settings (setting_key, setting_value, setting_type, description) VALUES
('clinic_name', 'عيادة الأسنان المتخصصة', 'string', 'اسم العيادة'),
('clinic_name_en', 'Specialized Dental Clinic', 'string', 'Clinic name in English'),
('clinic_address', 'الرياض، المملكة العربية السعودية', 'string', 'عنوان العيادة'),
('clinic_phone', '+966501234567', 'string', 'هاتف العيادة'),
('clinic_email', 'info@dentalclinic.com', 'string', 'بريد العيادة الإلكتروني'),
('currency', 'ريال سعودي', 'string', 'العملة المستخدمة'),
('currency_symbol', 'ر.س', 'string', 'رمز العملة'),
('tax_rate', '15', 'number', 'معدل الضريبة المضافة'),
('appointment_duration', '30', 'number', 'مدة الموعد الافتراضية بالدقائق'),
('working_hours_start', '08:00', 'string', 'بداية ساعات العمل'),
('working_hours_end', '20:00', 'string', 'نهاية ساعات العمل'),
('working_days', 'sunday,monday,tuesday,wednesday,thursday', 'string', 'أيام العمل'),
('backup_enabled', '1', 'boolean', 'تفعيل النسخ الاحتياطي التلقائي'),
('notification_enabled', '1', 'boolean', 'تفعيل الإشعارات'),
('default_language', 'ar', 'string', 'اللغة الافتراضية'),
('timezone', 'Asia/Riyadh', 'string', 'المنطقة الزمنية'),
('date_format', 'Y-m-d', 'string', 'تنسيق التاريخ'),
('time_format', 'H:i', 'string', 'تنسيق الوقت');

-- إدراج موظف طبيب افتراضي
INSERT INTO staff (employee_id, first_name, last_name, email, phone, specialization, qualification, user_type, hire_date, salary, is_active, created_at) VALUES
('DOC001', 'د. أحمد', 'محمد', 'doctor@dentalclinic.com', '+966501234568', 'طب الأسنان العام', 'بكالوريوس طب الأسنان', 'doctor', CURDATE(), 15000.00, 1, NOW());

-- إدراج موظف استقبال افتراضي
INSERT INTO staff (employee_id, first_name, last_name, email, phone, specialization, qualification, user_type, hire_date, salary, is_active, created_at) VALUES
('REC001', 'فاطمة', 'علي', 'receptionist@dentalclinic.com', '+966501234569', 'إدارة مكتبية', 'دبلوم إدارة', 'receptionist', CURDATE(), 5000.00, 1, NOW());

-- إدراج مستخدمين للموظفين
INSERT INTO users (username, email, password_hash, user_type, first_name, last_name, staff_id, is_active, created_at) VALUES
('doctor', 'doctor@dentalclinic.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'doctor', 'د. أحمد', 'محمد', 1, 1, NOW()),
('receptionist', 'receptionist@dentalclinic.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'receptionist', 'فاطمة', 'علي', 2, 1, NOW());

-- إدراج مريض تجريبي
INSERT INTO patients (patient_number, first_name, last_name, date_of_birth, gender, phone, email, address, emergency_contact_name, emergency_contact_phone, medical_history, allergies, current_medications, insurance_info, is_active, created_at) VALUES
('P001', 'محمد', 'أحمد', '1990-01-15', 'male', '+966501234570', 'patient@example.com', 'الرياض، حي النخيل', 'سارة أحمد', '+966501234571', 'لا يوجد تاريخ مرضي مهم', 'لا توجد حساسية معروفة', 'لا يتناول أدوية حالياً', 'تأمين طبي - شركة التأمين الوطنية', 1, NOW());

-- إدراج إشعار ترحيبي
INSERT INTO notifications (user_id, title, title_ar, message, message_ar, type, is_read, created_at) VALUES
(1, 'Welcome to Dental Clinic Management System', 'مرحباً بك في نظام إدارة عيادة الأسنان', 'Welcome! Your system is ready to use.', 'مرحباً! النظام جاهز للاستخدام.', 'info', 0, NOW());

