-- البيانات الأولية لنظام إدارة عيادة الأسنان (بسيط)
-- Initial Data for Dental Clinic Management System (Simple)

-- إدراج المستخدم المدير الافتراضي
-- Default admin user (username: admin, password: admin123)
INSERT INTO users (username, email, password_hash, user_type, first_name, last_name, is_active, created_at) VALUES
('admin', 'admin@dentalclinic.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'مدير', 'النظام', 1, NOW());

-- إدراج أنواع الإجراءات الأساسية
INSERT INTO procedure_types (type_name, type_name_ar, default_cost, description, description_ar, is_active) VALUES
('Consultation', 'استشارة', 100.00, 'General dental consultation', 'استشارة أسنان عامة', 1),
('Cleaning', 'تنظيف', 150.00, 'Professional teeth cleaning', 'تنظيف أسنان احترافي', 1),
('Filling', 'حشو', 200.00, 'Dental filling', 'حشو أسنان', 1),
('Extraction', 'خلع', 250.00, 'Tooth extraction', 'خلع سن', 1),
('Root Canal', 'علاج عصب', 800.00, 'Root canal treatment', 'علاج عصب السن', 1);

-- إدراج إعدادات النظام الافتراضية
INSERT INTO settings (setting_key, setting_value, setting_type, description) VALUES
('clinic_name', 'عيادة الأسنان المتخصصة', 'string', 'اسم العيادة'),
('clinic_phone', '+966501234567', 'string', 'هاتف العيادة'),
('clinic_email', 'info@dentalclinic.com', 'string', 'بريد العيادة الإلكتروني'),
('currency_symbol', 'ر.س', 'string', 'رمز العملة'),
('tax_rate', '15', 'number', 'معدل الضريبة المضافة');

-- إدراج إشعار ترحيبي
INSERT INTO notifications (user_id, title, title_ar, message, message_ar, type, is_read, created_at) VALUES
(1, 'Welcome to Dental Clinic Management System', 'مرحباً بك في نظام إدارة عيادة الأسنان', 'Welcome! Your system is ready to use.', 'مرحباً! النظام جاهز للاستخدام.', 'info', 0, NOW());

