            </main>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="<?php echo SITE_URL; ?>/assets/js/jquery.min.js"></script>
    <script src="<?php echo SITE_URL; ?>/assets/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // تغيير اللغة
        function changeLanguage(lang) {
            fetch('<?php echo SITE_URL; ?>/includes/change_language.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'language=' + lang
            }).then(() => {
                window.location.reload();
            });
        }
        
        // تحميل الإشعارات
        function loadNotifications() {
            fetch('<?php echo SITE_URL; ?>/includes/get_notifications.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const notificationsList = document.getElementById('notifications-list');
                        const notificationCount = document.getElementById('notification-count');
                        
                        notificationCount.textContent = data.unread_count;
                        
                        if (data.notifications.length > 0) {
                            notificationsList.innerHTML = '';
                            data.notifications.forEach(notification => {
                                const notificationItem = document.createElement('li');
                                notificationItem.innerHTML = `
                                    <a class="dropdown-item ${notification.is_read ? '' : 'fw-bold'}" href="#" onclick="markAsRead(${notification.notification_id})">
                                        <div class="d-flex align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">${notification.title}</h6>
                                                <p class="mb-1 small">${notification.message}</p>
                                                <small class="text-muted">${notification.created_at}</small>
                                            </div>
                                        </div>
                                    </a>
                                `;
                                notificationsList.appendChild(notificationItem);
                            });
                        }
                    }
                })
                .catch(error => console.error('Error loading notifications:', error));
        }
        
        // تمييز الإشعار كمقروء
        function markAsRead(notificationId) {
            fetch('<?php echo SITE_URL; ?>/includes/mark_notification_read.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'notification_id=' + notificationId
            }).then(() => {
                loadNotifications();
            });
        }
        
        // تحميل الإشعارات عند تحميل الصفحة
        document.addEventListener('DOMContentLoaded', function() {
            loadNotifications();
            
            // تحديث الإشعارات كل دقيقة
            setInterval(loadNotifications, 60000);
            
            // إعداد الشريط الجانبي للهواتف المحمولة
            const sidebarToggle = document.querySelector('.navbar-toggler');
            const sidebar = document.getElementById('sidebar');
            
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('show');
                });
                
                // إغلاق الشريط الجانبي عند النقر خارجه
                document.addEventListener('click', function(e) {
                    if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                        sidebar.classList.remove('show');
                    }
                });
            }
        });
        
        // وظائف مساعدة
        function confirmDelete(message) {
            return confirm(message || '<?php echo getText('confirm_delete') ?? 'هل أنت متأكد من الحذف؟'; ?>');
        }
        
        function showAlert(message, type = 'info') {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
            alertDiv.innerHTML = `
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            const mainContent = document.querySelector('.main-content');
            mainContent.insertBefore(alertDiv, mainContent.firstChild);
            
            // إزالة التنبيه تلقائياً بعد 5 ثوان
            setTimeout(() => {
                alertDiv.remove();
            }, 5000);
        }
        
        // تنسيق التواريخ
        function formatDate(dateString) {
            const date = new Date(dateString);
            const options = { 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                <?php if ($currentLanguage === 'ar'): ?>
                locale: 'ar-SA'
                <?php else: ?>
                locale: 'en-US'
                <?php endif; ?>
            };
            return date.toLocaleDateString('<?php echo $currentLanguage === 'ar' ? 'ar-SA' : 'en-US'; ?>', options);
        }
        
        // تنسيق الأرقام
        function formatNumber(number, decimals = 0) {
            return new Intl.NumberFormat('<?php echo $currentLanguage === 'ar' ? 'ar-SA' : 'en-US'; ?>', {
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals
            }).format(number);
        }
        
        // تنسيق العملة
        function formatCurrency(amount) {
            return formatNumber(amount, 2) + ' <?php echo getText('currency') ?? 'ريال'; ?>';
        }
        
        // التحقق من صحة البريد الإلكتروني
        function validateEmail(email) {
            const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
        }
        
        // التحقق من صحة رقم الهاتف السعودي
        function validateSaudiPhone(phone) {
            const re = /^(\+966|966|05)[0-9]{8}$/;
            return re.test(phone.replace(/\s/g, ''));
        }
        
        // تنسيق رقم الهاتف
        function formatPhone(phone) {
            const cleaned = phone.replace(/\D/g, '');
            if (cleaned.startsWith('966')) {
                return '+' + cleaned;
            } else if (cleaned.startsWith('05')) {
                return '+966' + cleaned.substring(1);
            }
            return phone;
        }
    </script>
    
    <?php if (isset($additionalJS)): ?>
        <?php echo $additionalJS; ?>
    <?php endif; ?>
</body>
</html>

