<?php
/**
 * ملف جلب الإشعارات
 * Get Notifications File
 */

require_once 'functions.php';

// التحقق من تسجيل الدخول
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$userId = $_SESSION['user_id'];

try {
    // جلب الإشعارات غير المقروءة
    $unreadNotifications = getUnreadNotifications($userId);
    
    // جلب آخر 10 إشعارات
    $sql = "SELECT * FROM notifications WHERE user_id = ? ORDER BY created_at DESC LIMIT 10";
    $stmt = executeQuery($sql, [$userId]);
    $allNotifications = $stmt ? $stmt->fetchAll() : [];
    
    // تنسيق الإشعارات
    $formattedNotifications = [];
    foreach ($allNotifications as $notification) {
        $currentLang = getCurrentLanguage();
        $formattedNotifications[] = [
            'notification_id' => $notification['notification_id'],
            'title' => $currentLang === 'ar' ? $notification['title_ar'] : $notification['title'],
            'message' => $currentLang === 'ar' ? $notification['message_ar'] : $notification['message'],
            'type' => $notification['type'],
            'is_read' => (bool)$notification['is_read'],
            'created_at' => formatDateTime($notification['created_at'])
        ];
    }
    
    echo json_encode([
        'success' => true,
        'notifications' => $formattedNotifications,
        'unread_count' => count($unreadNotifications)
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching notifications'
    ]);
}
?>

