<?php
/**
 * قالب الرأس المشترك
 * Common Header Template
 */

if (!defined('SYSTEM_LOADED')) {
    require_once __DIR__ . '/functions.php';
    define('SYSTEM_LOADED', true);
}

// التحقق من تسجيل الدخول
if (!isLoggedIn()) {
    header('Location: ' . SITE_URL . '/index.php');
    exit;
}

$currentUser = $_SESSION;
$currentLanguage = getCurrentLanguage();
$isRTL = $currentLanguage === 'ar';
?>
<!DOCTYPE html>
<html lang="<?php echo $currentLanguage; ?>" dir="<?php echo $isRTL ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?><?php echo getText('system_name'); ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="<?php echo SITE_URL; ?>/assets/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #667eea;
            --secondary-color: #764ba2;
            --success-color: #51cf66;
            --danger-color: #ff6b6b;
            --warning-color: #ffd43b;
            --info-color: #74c0fc;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f6fa;
            <?php if ($isRTL): ?>
            direction: rtl;
            text-align: right;
            <?php endif; ?>
        }
        
        .navbar {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .navbar-brand {
            font-weight: 600;
            font-size: 1.5rem;
        }
        
        .sidebar {
            background: white;
            min-height: calc(100vh - 76px);
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            padding: 0;
        }
        
        .sidebar .nav-link {
            color: #495057;
            padding: 15px 20px;
            border-bottom: 1px solid #e9ecef;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            <?php if ($isRTL): ?>
            border-right: 4px solid white;
            <?php else: ?>
            border-left: 4px solid white;
            <?php endif; ?>
        }
        
        .sidebar .nav-link i {
            width: 20px;
            <?php if ($isRTL): ?>
            margin-left: 10px;
            <?php else: ?>
            margin-right: 10px;
            <?php endif; ?>
        }
        
        .main-content {
            padding: 30px;
            min-height: calc(100vh - 76px);
        }
        
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            margin-bottom: 30px;
        }
        
        .card-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 20px;
            border: none;
        }
        
        .card-body {
            padding: 25px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border: none;
            border-radius: 8px;
            padding: 10px 20px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        .btn-success {
            background: linear-gradient(135deg, var(--success-color) 0%, #40c057 100%);
            border: none;
            border-radius: 8px;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, var(--danger-color) 0%, #ee5a52 100%);
            border: none;
            border-radius: 8px;
        }
        
        .btn-warning {
            background: linear-gradient(135deg, var(--warning-color) 0%, #fab005 100%);
            border: none;
            border-radius: 8px;
            color: #495057;
        }
        
        .btn-info {
            background: linear-gradient(135deg, var(--info-color) 0%, #339af0 100%);
            border: none;
            border-radius: 8px;
        }
        
        .table {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
        }
        
        .table thead th {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            border: none;
            padding: 15px;
            font-weight: 500;
        }
        
        .table tbody td {
            padding: 15px;
            border-color: #e9ecef;
            vertical-align: middle;
        }
        
        .table tbody tr:hover {
            background-color: #f8f9fa;
        }
        
        .form-control,
        .form-select {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus,
        .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .alert {
            border: none;
            border-radius: 10px;
            padding: 15px 20px;
        }
        
        .alert-success {
            background: linear-gradient(135deg, var(--success-color) 0%, #40c057 100%);
            color: white;
        }
        
        .alert-danger {
            background: linear-gradient(135deg, var(--danger-color) 0%, #ee5a52 100%);
            color: white;
        }
        
        .alert-warning {
            background: linear-gradient(135deg, var(--warning-color) 0%, #fab005 100%);
            color: #495057;
        }
        
        .alert-info {
            background: linear-gradient(135deg, var(--info-color) 0%, #339af0 100%);
            color: white;
        }
        
        .stats-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            margin-bottom: 30px;
        }
        
        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }
        
        .stats-card .icon {
            font-size: 3rem;
            margin-bottom: 15px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .stats-card .number {
            font-size: 2.5rem;
            font-weight: 700;
            color: #495057;
            margin-bottom: 5px;
        }
        
        .stats-card .label {
            color: #6c757d;
            font-weight: 500;
        }
        
        .dropdown-menu {
            border: none;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .dropdown-item {
            padding: 10px 20px;
            transition: all 0.3s ease;
        }
        
        .dropdown-item:hover {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
        }
        
        .breadcrumb {
            background: white;
            border-radius: 10px;
            padding: 15px 20px;
            margin-bottom: 30px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }
        
        .breadcrumb-item.active {
            color: var(--primary-color);
        }
        
        .page-header {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }
        
        .page-header h1 {
            color: #495057;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .page-header p {
            color: #6c757d;
            margin: 0;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 76px;
                left: -100%;
                width: 280px;
                z-index: 1000;
                transition: all 0.3s ease;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                padding: 20px 15px;
            }
            
            .stats-card {
                margin-bottom: 20px;
            }
        }
        
        /* RTL Specific Styles */
        <?php if ($isRTL): ?>
        .sidebar {
            right: 0;
            left: auto;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                right: -100%;
                left: auto;
            }
            
            .sidebar.show {
                right: 0;
            }
        }
        <?php endif; ?>
    </style>
    
    <?php if (isset($additionalCSS)): ?>
        <?php echo $additionalCSS; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container-fluid">
            <button class="navbar-toggler d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <a class="navbar-brand" href="<?php echo SITE_URL; ?>/pages/dashboard.php">
                <i class="fas fa-tooth me-2"></i>
                <?php echo getText('system_name'); ?>
            </a>
            
            <div class="navbar-nav ms-auto">
                <!-- Language Switcher -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-globe me-1"></i>
                        <?php echo $currentLanguage === 'ar' ? 'العربية' : 'English'; ?>
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#" onclick="changeLanguage('ar')">العربية</a></li>
                        <li><a class="dropdown-item" href="#" onclick="changeLanguage('en')">English</a></li>
                    </ul>
                </div>
                
                <!-- Notifications -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-bell"></i>
                        <span class="badge bg-danger rounded-pill" id="notification-count">0</span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" style="width: 300px;">
                        <li><h6 class="dropdown-header"><?php echo getText('notifications'); ?></h6></li>
                        <li><hr class="dropdown-divider"></li>
                        <li id="notifications-list">
                            <div class="text-center p-3">
                                <small class="text-muted"><?php echo getText('no_notifications') ?? 'لا توجد إشعارات'; ?></small>
                            </div>
                        </li>
                    </ul>
                </div>
                
                <!-- User Menu -->
                <div class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user-circle me-1"></i>
                        <?php echo htmlspecialchars($currentUser['username']); ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-user me-2"></i><?php echo getText('profile') ?? 'الملف الشخصي'; ?></a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i><?php echo getText('settings'); ?></a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo SITE_URL; ?>/logout.php"><i class="fas fa-sign-out-alt me-2"></i><?php echo getText('logout'); ?></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-lg-3 col-xl-2 sidebar collapse" id="sidebar">
                <div class="nav flex-column">
                    <?php
                    // تحديد القائمة حسب نوع المستخدم
                    $menuItems = [];
                    
                    switch ($currentUser['user_type']) {
                        case 'admin':
                            $menuItems = [
                                ['icon' => 'fas fa-tachometer-alt', 'text' => getText('dashboard'), 'url' => 'dashboard.php'],
                                ['icon' => 'fas fa-users', 'text' => getText('users'), 'url' => 'users.php'],
                                ['icon' => 'fas fa-user-tie', 'text' => getText('staff'), 'url' => 'staff.php'],
                                ['icon' => 'fas fa-user-injured', 'text' => getText('patients'), 'url' => 'patients.php'],
                                ['icon' => 'fas fa-procedures', 'text' => getText('procedures'), 'url' => 'procedures.php'],
                                ['icon' => 'fas fa-credit-card', 'text' => getText('payments'), 'url' => 'payments.php'],
                                ['icon' => 'fas fa-file-invoice', 'text' => getText('invoices'), 'url' => 'invoices.php'],
                                ['icon' => 'fas fa-calendar-alt', 'text' => getText('appointments'), 'url' => 'appointments.php'],
                                ['icon' => 'fas fa-chart-bar', 'text' => getText('reports'), 'url' => 'reports.php'],
                                ['icon' => 'fas fa-database', 'text' => getText('backup'), 'url' => 'backup.php'],
                                ['icon' => 'fas fa-cog', 'text' => getText('settings'), 'url' => 'settings.php'],
                            ];
                            break;
                            
                        case 'doctor':
                            $menuItems = [
                                ['icon' => 'fas fa-tachometer-alt', 'text' => getText('dashboard'), 'url' => 'dashboard.php'],
                                ['icon' => 'fas fa-user-injured', 'text' => getText('patients'), 'url' => 'patients.php'],
                                ['icon' => 'fas fa-procedures', 'text' => getText('procedures'), 'url' => 'procedures.php'],
                                ['icon' => 'fas fa-calendar-alt', 'text' => getText('appointments'), 'url' => 'appointments.php'],
                                ['icon' => 'fas fa-chart-bar', 'text' => getText('reports'), 'url' => 'reports.php'],
                            ];
                            break;
                            
                        case 'receptionist':
                            $menuItems = [
                                ['icon' => 'fas fa-tachometer-alt', 'text' => getText('dashboard'), 'url' => 'dashboard.php'],
                                ['icon' => 'fas fa-user-injured', 'text' => getText('patients'), 'url' => 'patients.php'],
                                ['icon' => 'fas fa-calendar-alt', 'text' => getText('appointments'), 'url' => 'appointments.php'],
                                ['icon' => 'fas fa-credit-card', 'text' => getText('payments'), 'url' => 'payments.php'],
                                ['icon' => 'fas fa-file-invoice', 'text' => getText('invoices'), 'url' => 'invoices.php'],
                            ];
                            break;
                    }
                    
                    foreach ($menuItems as $item):
                        $isActive = basename($_SERVER['PHP_SELF']) === $item['url'] ? 'active' : '';
                    ?>
                        <a class="nav-link <?php echo $isActive; ?>" href="<?php echo $item['url']; ?>">
                            <i class="<?php echo $item['icon']; ?>"></i>
                            <?php echo $item['text']; ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-lg-9 col-xl-10 main-content">
                <?php displayFlashMessage(); ?>

