<?php
/**
 * ملف تمييز الإشعارات كمقروءة
 * Mark Notification as Read File
 */

require_once 'functions.php';

// التحقق من تسجيل الدخول
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['notification_id'])) {
    $notificationId = (int)$_POST['notification_id'];
    $userId = $_SESSION['user_id'];
    
    try {
        // التحقق من أن الإشعار يخص المستخدم الحالي
        $sql = "SELECT notification_id FROM notifications WHERE notification_id = ? AND user_id = ?";
        $stmt = executeQuery($sql, [$notificationId, $userId]);
        
        if ($stmt && $stmt->fetch()) {
            // تمييز الإشعار كمقروء
            if (markNotificationAsRead($notificationId)) {
                echo json_encode(['success' => true, 'message' => 'Notification marked as read']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to mark notification as read']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Notification not found']);
        }
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Error updating notification']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>

