<?php
/**
 * صفحة تسجيل الدخول الرئيسية
 * Main Login Page
 */

// تضمين الملفات المطلوبة
require_once 'includes/functions.php';

// التحقق من تسجيل الدخول المسبق
if (isLoggedIn()) {
    redirectToDashboard();
}

// معالجة تسجيل الدخول
$error_message = '';
$success_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitizeInput($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember_me = isset($_POST['remember_me']);
    
    if (empty($username) || empty($password)) {
        $error_message = getText('invalid_credentials');
    } else {
        // البحث عن المستخدم
        $sql = "SELECT user_id, username, password_hash, user_type, is_active FROM users WHERE (username = ? OR email = ?) AND is_active = 1";
        $stmt = executeQuery($sql, [$username, $username]);
        
        if ($stmt && $user = $stmt->fetch()) {
            if (verifyPassword($password, $user['password_hash'])) {
                // تسجيل دخول ناجح
                loginUser($user['user_id'], $user['user_type'], $user['username']);
                
                // تحديث وقت آخر تسجيل دخول
                $updateSql = "UPDATE users SET last_login = NOW() WHERE user_id = ?";
                executeNonQuery($updateSql, [$user['user_id']]);
                
                // إعداد تذكر المستخدم
                if ($remember_me) {
                    setcookie('remember_user', $user['username'], time() + (30 * 24 * 60 * 60), '/');
                }
                
                $success_message = getText('login_success');
                
                // إعادة التوجيه بعد ثانيتين
                header("refresh:2;url=" . ($_GET['redirect'] ?? 'pages/dashboard.php'));
            } else {
                $error_message = getText('invalid_credentials');
                logUserLogin($user['user_id'], 'failed', 'Invalid password');
            }
        } else {
            $error_message = getText('invalid_credentials');
            // محاولة تسجيل فاشلة لمستخدم غير موجود
            $sql = "SELECT user_id FROM users WHERE username = ? OR email = ?";
            $stmt = executeQuery($sql, [$username, $username]);
            if ($stmt && $user = $stmt->fetch()) {
                logUserLogin($user['user_id'], 'failed', 'Account disabled or not found');
            }
        }
    }
}

// الحصول على اسم المستخدم المحفوظ
$remembered_username = $_COOKIE['remember_user'] ?? '';
?>
<!DOCTYPE html>
<html lang="<?php echo getCurrentLanguage(); ?>" dir="<?php echo getCurrentLanguage() === 'ar' ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo getText('login'); ?> - <?php echo getText('system_name'); ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            overflow: hidden;
            max-width: 450px;
            width: 100%;
        }
        
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px 30px;
            text-align: center;
        }
        
        .login-header h1 {
            font-size: 2rem;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .login-header p {
            opacity: 0.9;
            margin: 0;
        }
        
        .login-body {
            padding: 40px 30px;
        }
        
        .form-floating {
            margin-bottom: 20px;
        }
        
        .form-floating input {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 12px 15px;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        .form-floating input:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .form-floating label {
            padding: 12px 15px;
            color: #6c757d;
        }
        
        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 30px;
            font-size: 16px;
            font-weight: 600;
            color: white;
            width: 100%;
            transition: all 0.3s ease;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .form-check {
            margin: 20px 0;
        }
        
        .form-check-input:checked {
            background-color: #667eea;
            border-color: #667eea;
        }
        
        .language-switcher {
            position: absolute;
            top: 20px;
            right: 20px;
        }
        
        .language-switcher .btn {
            background: rgba(255, 255, 255, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
            border-radius: 8px;
            padding: 8px 15px;
            margin: 0 2px;
            transition: all 0.3s ease;
        }
        
        .language-switcher .btn:hover,
        .language-switcher .btn.active {
            background: rgba(255, 255, 255, 0.3);
            color: white;
        }
        
        .alert {
            border-radius: 10px;
            border: none;
            margin-bottom: 20px;
        }
        
        .alert-danger {
            background: linear-gradient(135deg, #ff6b6b 0%, #ee5a52 100%);
            color: white;
        }
        
        .alert-success {
            background: linear-gradient(135deg, #51cf66 0%, #40c057 100%);
            color: white;
        }
        
        .footer-text {
            text-align: center;
            margin-top: 30px;
            color: #6c757d;
            font-size: 14px;
        }
        
        .dental-icon {
            font-size: 3rem;
            margin-bottom: 20px;
            opacity: 0.9;
        }
        
        @media (max-width: 576px) {
            .login-card {
                margin: 10px;
                border-radius: 15px;
            }
            
            .login-header {
                padding: 30px 20px 20px;
            }
            
            .login-body {
                padding: 30px 20px;
            }
            
            .language-switcher {
                position: relative;
                top: auto;
                right: auto;
                text-align: center;
                margin-bottom: 20px;
            }
        }
    </style>
</head>
<body>
    <!-- Language Switcher -->
    <div class="language-switcher">
        <a href="?lang=ar" class="btn <?php echo getCurrentLanguage() === 'ar' ? 'active' : ''; ?>">العربية</a>
        <a href="?lang=en" class="btn <?php echo getCurrentLanguage() === 'en' ? 'active' : ''; ?>">English</a>
    </div>

    <div class="login-container">
        <div class="login-card">
            <!-- Header -->
            <div class="login-header">
                <div class="dental-icon">🦷</div>
                <h1><?php echo getText('system_name'); ?></h1>
                <p><?php echo getText('clinic_name'); ?></p>
            </div>
            
            <!-- Body -->
            <div class="login-body">
                <?php if (!empty($error_message)): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <?php echo $error_message; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($success_message)): ?>
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        <?php echo $success_message; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" action="">
                    <div class="form-floating">
                        <input type="text" class="form-control" id="username" name="username" 
                               placeholder="<?php echo getText('username'); ?>" 
                               value="<?php echo htmlspecialchars($remembered_username); ?>" required>
                        <label for="username"><?php echo getText('username'); ?> / <?php echo getText('email'); ?></label>
                    </div>
                    
                    <div class="form-floating">
                        <input type="password" class="form-control" id="password" name="password" 
                               placeholder="<?php echo getText('password'); ?>" required>
                        <label for="password"><?php echo getText('password'); ?></label>
                    </div>
                    
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="remember_me" name="remember_me">
                        <label class="form-check-label" for="remember_me">
                            <?php echo getText('remember_me') ?? 'تذكرني'; ?>
                        </label>
                    </div>
                    
                    <button type="submit" class="btn btn-login">
                        <i class="fas fa-sign-in-alt me-2"></i>
                        <?php echo getText('login'); ?>
                    </button>
                </form>
                
                <div class="footer-text">
                    <p><?php echo getText('copyright'); ?> © <?php echo date('Y'); ?></p>
                    <p><?php echo getText('powered_by'); ?> <?php echo getText('system_name'); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/jquery.min.js"></script>
    
    <!-- Font Awesome -->
    <script src="https://kit.fontawesome.com/your-fontawesome-kit.js" crossorigin="anonymous"></script>
    
    <script>
        // معالجة تغيير اللغة
        document.addEventListener('DOMContentLoaded', function() {
            const langButtons = document.querySelectorAll('.language-switcher .btn');
            langButtons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const url = new URL(this.href);
                    const lang = url.searchParams.get('lang');
                    
                    // إرسال طلب AJAX لتغيير اللغة
                    fetch('includes/change_language.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: 'language=' + lang
                    }).then(() => {
                        window.location.reload();
                    });
                });
            });
            
            // تركيز على حقل اسم المستخدم إذا كان فارغاً
            const usernameField = document.getElementById('username');
            if (usernameField && !usernameField.value) {
                usernameField.focus();
            } else {
                const passwordField = document.getElementById('password');
                if (passwordField) {
                    passwordField.focus();
                }
            }
        });
    </script>
</body>
</html>

<?php
// معالجة تغيير اللغة
if (isset($_GET['lang']) && in_array($_GET['lang'], SUPPORTED_LANGUAGES)) {
    setLanguage($_GET['lang']);
    header('Location: index.php');
    exit;
}
?>

