<?php
/**
 * English Language File
 * ملف اللغة الإنجليزية
 */

return [
    // General
    'welcome' => 'Welcome',
    'home' => 'Home',
    'dashboard' => 'Dashboard',
    'login' => 'Login',
    'logout' => 'Logout',
    'register' => 'Register',
    'save' => 'Save',
    'cancel' => 'Cancel',
    'delete' => 'Delete',
    'edit' => 'Edit',
    'view' => 'View',
    'add' => 'Add',
    'search' => 'Search',
    'filter' => 'Filter',
    'print' => 'Print',
    'export' => 'Export',
    'import' => 'Import',
    'back' => 'Back',
    'next' => 'Next',
    'previous' => 'Previous',
    'submit' => 'Submit',
    'reset' => 'Reset',
    'confirm' => 'Confirm',
    'yes' => 'Yes',
    'no' => 'No',
    'ok' => 'OK',
    'close' => 'Close',
    'loading' => 'Loading...',
    'please_wait' => 'Please wait...',
    'success' => 'Success',
    'error' => 'Error',
    'warning' => 'Warning',
    'info' => 'Information',
    'required' => 'Required',
    'optional' => 'Optional',
    'select' => 'Select',
    'choose_file' => 'Choose File',
    'upload' => 'Upload',
    'download' => 'Download',
    'date' => 'Date',
    'time' => 'Time',
    'name' => 'Name',
    'email' => 'Email',
    'phone' => 'Phone',
    'address' => 'Address',
    'notes' => 'Notes',
    'description' => 'Description',
    'status' => 'Status',
    'active' => 'Active',
    'inactive' => 'Inactive',
    'enabled' => 'Enabled',
    'disabled' => 'Disabled',
    'total' => 'Total',
    'amount' => 'Amount',
    'quantity' => 'Quantity',
    'price' => 'Price',
    'discount' => 'Discount',
    'tax' => 'Tax',
    'subtotal' => 'Subtotal',
    'grand_total' => 'Grand Total',
    
    // System
    'system_name' => 'Dental Clinic Management System',
    'clinic_name' => 'Specialized Dental Clinic',
    'version' => 'Version',
    'copyright' => 'All Rights Reserved',
    'powered_by' => 'Powered by',
    
    // Users
    'users' => 'Users',
    'user' => 'User',
    'username' => 'Username',
    'password' => 'Password',
    'confirm_password' => 'Confirm Password',
    'current_password' => 'Current Password',
    'new_password' => 'New Password',
    'change_password' => 'Change Password',
    'first_name' => 'First Name',
    'last_name' => 'Last Name',
    'full_name' => 'Full Name',
    'user_type' => 'User Type',
    'admin' => 'Admin',
    'doctor' => 'Doctor',
    'receptionist' => 'Receptionist',
    'last_login' => 'Last Login',
    'login_time' => 'Login Time',
    'login_status' => 'Login Status',
    'login_success' => 'Login successful',
    'login_failed' => 'Login failed',
    'logout_success' => 'Logout successful',
    'invalid_credentials' => 'Invalid credentials',
    'account_disabled' => 'Account disabled',
    'session_expired' => 'Session expired',
    
    // Staff
    'staff' => 'Staff',
    'staff_member' => 'Staff Member',
    'employee_id' => 'Employee ID',
    'add_staff' => 'Add Staff',
    'manage_staff' => 'Manage Staff',
    'staff_list' => 'Staff List',
    'staff_details' => 'Staff Details',
    'date_of_birth' => 'Date of Birth',
    'gender' => 'Gender',
    'male' => 'Male',
    'female' => 'Female',
    'qualification' => 'Qualification',
    'specialization' => 'Specialization',
    'experience_years' => 'Years of Experience',
    'salary' => 'Salary',
    'hire_date' => 'Hire Date',
    'staff_added' => 'Staff added successfully',
    'staff_updated' => 'Staff updated successfully',
    'staff_deleted' => 'Staff deleted successfully',
    
    // Patients
    'patients' => 'Patients',
    'patient' => 'Patient',
    'patient_id' => 'Patient ID',
    'patient_number' => 'Patient Number',
    'add_patient' => 'Add Patient',
    'manage_patients' => 'Manage Patients',
    'patient_list' => 'Patient List',
    'patient_details' => 'Patient Details',
    'patient_profile' => 'Patient Profile',
    'emergency_contact' => 'Emergency Contact',
    'emergency_contact_name' => 'Emergency Contact Name',
    'emergency_contact_phone' => 'Emergency Contact Phone',
    'medical_history' => 'Medical History',
    'allergies' => 'Allergies',
    'current_medications' => 'Current Medications',
    'chronic_conditions' => 'Chronic Conditions',
    'insurance_info' => 'Insurance Information',
    'age' => 'Age',
    'patient_added' => 'Patient added successfully',
    'patient_updated' => 'Patient updated successfully',
    'patient_deleted' => 'Patient deleted successfully',
    
    // Procedures
    'procedures' => 'Procedures',
    'procedure' => 'Procedure',
    'procedure_types' => 'Procedure Types',
    'procedure_type' => 'Procedure Type',
    'add_procedure' => 'Add Procedure',
    'manage_procedures' => 'Manage Procedures',
    'procedure_list' => 'Procedure List',
    'procedure_details' => 'Procedure Details',
    'procedure_date' => 'Procedure Date',
    'tooth_involved' => 'Tooth Involved',
    'additional_charges' => 'Additional Charges',
    'procedure_added' => 'Procedure added successfully',
    'procedure_updated' => 'Procedure updated successfully',
    'procedure_deleted' => 'Procedure deleted successfully',
    
    // Payments
    'payments' => 'Payments',
    'payment' => 'Payment',
    'payment_id' => 'Payment ID',
    'payment_date' => 'Payment Date',
    'amount_paid' => 'Amount Paid',
    'payment_method' => 'Payment Method',
    'cash' => 'Cash',
    'card' => 'Card',
    'bank_transfer' => 'Bank Transfer',
    'insurance' => 'Insurance',
    'payment_reference' => 'Payment Reference',
    'received_by' => 'Received By',
    'total_paid' => 'Total Paid',
    'balance_due' => 'Balance Due',
    'payment_added' => 'Payment added successfully',
    'payment_updated' => 'Payment updated successfully',
    'payment_deleted' => 'Payment deleted successfully',
    
    // Invoices
    'invoices' => 'Invoices',
    'invoice' => 'Invoice',
    'invoice_id' => 'Invoice ID',
    'invoice_number' => 'Invoice Number',
    'invoice_date' => 'Invoice Date',
    'due_date' => 'Due Date',
    'create_invoice' => 'Create Invoice',
    'manage_invoices' => 'Manage Invoices',
    'invoice_list' => 'Invoice List',
    'invoice_details' => 'Invoice Details',
    'invoice_items' => 'Invoice Items',
    'unit_price' => 'Unit Price',
    'total_price' => 'Total Price',
    'tax_amount' => 'Tax Amount',
    'discount_amount' => 'Discount Amount',
    'paid_amount' => 'Paid Amount',
    'draft' => 'Draft',
    'sent' => 'Sent',
    'paid' => 'Paid',
    'overdue' => 'Overdue',
    'cancelled' => 'Cancelled',
    'invoice_created' => 'Invoice created successfully',
    'invoice_updated' => 'Invoice updated successfully',
    'invoice_deleted' => 'Invoice deleted successfully',
    
    // Appointments
    'appointments' => 'Appointments',
    'appointment' => 'Appointment',
    'appointment_date' => 'Appointment Date',
    'appointment_time' => 'Appointment Time',
    'duration' => 'Duration',
    'duration_minutes' => 'Duration (Minutes)',
    'add_appointment' => 'Add Appointment',
    'manage_appointments' => 'Manage Appointments',
    'appointment_list' => 'Appointment List',
    'appointment_details' => 'Appointment Details',
    'scheduled' => 'Scheduled',
    'confirmed' => 'Confirmed',
    'completed' => 'Completed',
    'no_show' => 'No Show',
    'reminder_sent' => 'Reminder Sent',
    'created_by' => 'Created By',
    'appointment_added' => 'Appointment added successfully',
    'appointment_updated' => 'Appointment updated successfully',
    'appointment_deleted' => 'Appointment deleted successfully',
    
    // Reports
    'reports' => 'Reports',
    'report' => 'Report',
    'all_invoices_report' => 'All Invoices Report',
    'procedure_report' => 'Procedure Report',
    'staff_record' => 'Staff Record',
    'date_wise_invoice_report' => 'Date Wise Invoice Report',
    'date_wise_procedure_report' => 'Date Wise Procedure Report',
    'patient_info_record' => 'Patient Info Record',
    'user_login_details_report' => 'User Login Details Report',
    'from_date' => 'From Date',
    'to_date' => 'To Date',
    'generate_report' => 'Generate Report',
    'report_generated' => 'Report generated successfully',
    
    // Backup
    'backup' => 'Backup',
    'backups' => 'Backups',
    'create_backup' => 'Create Backup',
    'restore_backup' => 'Restore Backup',
    'backup_list' => 'Backup List',
    'backup_name' => 'Backup Name',
    'backup_size' => 'Backup Size',
    'backup_type' => 'Backup Type',
    'manual' => 'Manual',
    'automatic' => 'Automatic',
    'backup_created' => 'Backup created successfully',
    'backup_restored' => 'Backup restored successfully',
    'backup_deleted' => 'Backup deleted successfully',
    
    // Settings
    'settings' => 'Settings',
    'general_settings' => 'General Settings',
    'system_settings' => 'System Settings',
    'clinic_settings' => 'Clinic Settings',
    'clinic_address' => 'Clinic Address',
    'clinic_phone' => 'Clinic Phone',
    'clinic_email' => 'Clinic Email',
    'working_hours' => 'Working Hours',
    'tax_rate' => 'Tax Rate',
    'currency' => 'Currency',
    'appointment_duration' => 'Default Appointment Duration',
    'backup_enabled' => 'Backup Enabled',
    'notification_enabled' => 'Notifications Enabled',
    'settings_updated' => 'Settings updated successfully',
    
    // Notifications
    'notifications' => 'Notifications',
    'notification' => 'Notification',
    'mark_as_read' => 'Mark as Read',
    'mark_all_as_read' => 'Mark All as Read',
    'unread_notifications' => 'Unread Notifications',
    'notification_title' => 'Notification Title',
    'notification_message' => 'Notification Message',
    'notification_type' => 'Notification Type',
    'notification_sent' => 'Notification sent successfully',
    
    // Language
    'language' => 'Language',
    'arabic' => 'Arabic',
    'english' => 'English',
    'change_language' => 'Change Language',
    'language_changed' => 'Language changed successfully',
    
    // Error Messages
    'error_occurred' => 'An error occurred',
    'invalid_input' => 'Invalid input',
    'required_field' => 'This field is required',
    'invalid_email' => 'Invalid email address',
    'invalid_phone' => 'Invalid phone number',
    'password_too_short' => 'Password is too short',
    'passwords_not_match' => 'Passwords do not match',
    'user_not_found' => 'User not found',
    'patient_not_found' => 'Patient not found',
    'staff_not_found' => 'Staff not found',
    'procedure_not_found' => 'Procedure not found',
    'invoice_not_found' => 'Invoice not found',
    'appointment_not_found' => 'Appointment not found',
    'access_denied' => 'Access denied',
    'permission_denied' => 'You do not have permission to access this',
    'database_error' => 'Database error',
    'file_upload_error' => 'File upload error',
    'file_not_found' => 'File not found',
    'invalid_file_type' => 'Invalid file type',
    'file_too_large' => 'File is too large',
    
    // Success Messages
    'operation_successful' => 'Operation completed successfully',
    'data_saved' => 'Data saved successfully',
    'data_updated' => 'Data updated successfully',
    'data_deleted' => 'Data deleted successfully',
    'file_uploaded' => 'File uploaded successfully',
    'email_sent' => 'Email sent successfully',
    
    // Others
    'no_data_found' => 'No data found',
    'no_results' => 'No results found',
    'loading_data' => 'Loading data...',
    'processing' => 'Processing...',
    'please_select' => 'Please select',
    'all' => 'All',
    'none' => 'None',
    'other' => 'Other',
    'unknown' => 'Unknown',
    'not_applicable' => 'Not Applicable',
    'not_available' => 'Not Available',
    'coming_soon' => 'Coming Soon',
    'under_construction' => 'Under Construction',
    'maintenance_mode' => 'Maintenance Mode',
    'contact_admin' => 'Contact Administrator',
    'try_again' => 'Try Again',
    'refresh_page' => 'Refresh Page',
    'go_back' => 'Go Back',
    'go_home' => 'Go Home',
];
?>

