<?php
/**
 * لوحة تحكم المدير
 * Admin Dashboard
 */

$pageTitle = getText('dashboard');
require_once '../../includes/header.php';

// التحقق من صلاحيات المدير
if (!hasPermission('admin')) {
    header('Location: ../../index.php');
    exit;
}

// جلب الإحصائيات
try {
    // إحصائيات المرضى
    $sql = "SELECT COUNT(*) as total, COUNT(CASE WHEN is_active = 1 THEN 1 END) as active FROM patients";
    $stmt = executeQuery($sql);
    $patientStats = $stmt ? $stmt->fetch() : ['total' => 0, 'active' => 0];
    
    // إحصائيات الموظفين
    $sql = "SELECT COUNT(*) as total, COUNT(CASE WHEN is_active = 1 THEN 1 END) as active FROM staff";
    $stmt = executeQuery($sql);
    $staffStats = $stmt ? $stmt->fetch() : ['total' => 0, 'active' => 0];
    
    // إحصائيات الإجراءات لهذا الشهر
    $sql = "SELECT COUNT(*) as total, COALESCE(SUM(total_amount), 0) as revenue FROM procedures WHERE MONTH(procedure_date) = MONTH(CURDATE()) AND YEAR(procedure_date) = YEAR(CURDATE())";
    $stmt = executeQuery($sql);
    $procedureStats = $stmt ? $stmt->fetch() : ['total' => 0, 'revenue' => 0];
    
    // إحصائيات المواعيد لهذا الأسبوع
    $sql = "SELECT COUNT(*) as total, 
                   COUNT(CASE WHEN status = 'scheduled' THEN 1 END) as scheduled,
                   COUNT(CASE WHEN status = 'completed' THEN 1 END) as completed
            FROM appointments 
            WHERE WEEK(appointment_date) = WEEK(CURDATE()) AND YEAR(appointment_date) = YEAR(CURDATE())";
    $stmt = executeQuery($sql);
    $appointmentStats = $stmt ? $stmt->fetch() : ['total' => 0, 'scheduled' => 0, 'completed' => 0];
    
    // إحصائيات المدفوعات لهذا الشهر
    $sql = "SELECT COUNT(*) as total, COALESCE(SUM(amount_paid), 0) as total_paid FROM payments WHERE MONTH(payment_date) = MONTH(CURDATE()) AND YEAR(payment_date) = YEAR(CURDATE())";
    $stmt = executeQuery($sql);
    $paymentStats = $stmt ? $stmt->fetch() : ['total' => 0, 'total_paid' => 0];
    
    // الفواتير المعلقة
    $sql = "SELECT COUNT(*) as total, COALESCE(SUM(balance_due), 0) as total_due FROM invoices WHERE status IN ('sent', 'overdue') AND balance_due > 0";
    $stmt = executeQuery($sql);
    $pendingInvoices = $stmt ? $stmt->fetch() : ['total' => 0, 'total_due' => 0];
    
    // آخر المرضى المضافين
    $sql = "SELECT patient_id, CONCAT(first_name, ' ', last_name) as name, patient_number, phone, created_at 
            FROM patients 
            ORDER BY created_at DESC 
            LIMIT 5";
    $stmt = executeQuery($sql);
    $recentPatients = $stmt ? $stmt->fetchAll() : [];
    
    // المواعيد القادمة
    $sql = "SELECT a.appointment_id, a.appointment_date, a.appointment_time, a.status,
                   CONCAT(p.first_name, ' ', p.last_name) as patient_name,
                   CONCAT(s.first_name, ' ', s.last_name) as doctor_name,
                   pt.type_name_ar as procedure_type
            FROM appointments a
            JOIN patients p ON a.patient_id = p.patient_id
            JOIN staff s ON a.staff_id = s.staff_id
            LEFT JOIN procedure_types pt ON a.procedure_type_id = pt.procedure_type_id
            WHERE a.appointment_date >= CURDATE() AND a.status IN ('scheduled', 'confirmed')
            ORDER BY a.appointment_date, a.appointment_time
            LIMIT 5";
    $stmt = executeQuery($sql);
    $upcomingAppointments = $stmt ? $stmt->fetchAll() : [];
    
} catch (Exception $e) {
    $error_message = "خطأ في جلب البيانات: " . $e->getMessage();
}
?>

<!-- Page Header -->
<div class="page-header">
    <h1><?php echo getText('dashboard'); ?></h1>
    <p><?php echo getText('welcome'); ?> <?php echo htmlspecialchars($_SESSION['username']); ?> - <?php echo getText('admin'); ?></p>
</div>

<?php if (isset($error_message)): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-triangle me-2"></i>
        <?php echo $error_message; ?>
    </div>
<?php endif; ?>

<!-- Statistics Cards -->
<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="icon">
                <i class="fas fa-user-injured"></i>
            </div>
            <div class="number"><?php echo formatNumber($patientStats['active']); ?></div>
            <div class="label"><?php echo getText('active') . ' ' . getText('patients'); ?></div>
            <small class="text-muted"><?php echo getText('total'); ?>: <?php echo formatNumber($patientStats['total']); ?></small>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="icon">
                <i class="fas fa-user-tie"></i>
            </div>
            <div class="number"><?php echo formatNumber($staffStats['active']); ?></div>
            <div class="label"><?php echo getText('active') . ' ' . getText('staff'); ?></div>
            <small class="text-muted"><?php echo getText('total'); ?>: <?php echo formatNumber($staffStats['total']); ?></small>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="icon">
                <i class="fas fa-procedures"></i>
            </div>
            <div class="number"><?php echo formatNumber($procedureStats['total']); ?></div>
            <div class="label"><?php echo getText('procedures') . ' ' . getText('this_month') ?? 'هذا الشهر'; ?></div>
            <small class="text-muted"><?php echo formatCurrency($procedureStats['revenue']); ?></small>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="icon">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <div class="number"><?php echo formatNumber($appointmentStats['scheduled']); ?></div>
            <div class="label"><?php echo getText('scheduled') . ' ' . getText('appointments'); ?></div>
            <small class="text-muted"><?php echo getText('completed'); ?>: <?php echo formatNumber($appointmentStats['completed']); ?></small>
        </div>
    </div>
</div>

<!-- Financial Overview -->
<div class="row">
    <div class="col-lg-4 col-md-6">
        <div class="stats-card">
            <div class="icon text-success">
                <i class="fas fa-money-bill-wave"></i>
            </div>
            <div class="number text-success"><?php echo formatCurrency($paymentStats['total_paid']); ?></div>
            <div class="label"><?php echo getText('payments') . ' ' . getText('this_month') ?? 'هذا الشهر'; ?></div>
            <small class="text-muted"><?php echo formatNumber($paymentStats['total']); ?> <?php echo getText('transactions') ?? 'معاملة'; ?></small>
        </div>
    </div>
    
    <div class="col-lg-4 col-md-6">
        <div class="stats-card">
            <div class="icon text-warning">
                <i class="fas fa-file-invoice-dollar"></i>
            </div>
            <div class="number text-warning"><?php echo formatCurrency($pendingInvoices['total_due']); ?></div>
            <div class="label"><?php echo getText('pending_invoices') ?? 'الفواتير المعلقة'; ?></div>
            <small class="text-muted"><?php echo formatNumber($pendingInvoices['total']); ?> <?php echo getText('invoices'); ?></small>
        </div>
    </div>
    
    <div class="col-lg-4 col-md-6">
        <div class="stats-card">
            <div class="icon text-info">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="number text-info"><?php echo formatCurrency($procedureStats['revenue'] - $paymentStats['total_paid']); ?></div>
            <div class="label"><?php echo getText('outstanding_amount') ?? 'المبلغ المستحق'; ?></div>
            <small class="text-muted"><?php echo getText('this_month') ?? 'هذا الشهر'; ?></small>
        </div>
    </div>
</div>

<!-- Recent Activity -->
<div class="row">
    <!-- Recent Patients -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-user-plus me-2"></i>
                    <?php echo getText('recent_patients') ?? 'المرضى الجدد'; ?>
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($recentPatients)): ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th><?php echo getText('patient_number'); ?></th>
                                    <th><?php echo getText('name'); ?></th>
                                    <th><?php echo getText('phone'); ?></th>
                                    <th><?php echo getText('date'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentPatients as $patient): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($patient['patient_number']); ?></td>
                                        <td><?php echo htmlspecialchars($patient['name']); ?></td>
                                        <td><?php echo htmlspecialchars($patient['phone']); ?></td>
                                        <td><?php echo formatDate($patient['created_at']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="text-center mt-3">
                        <a href="patients.php" class="btn btn-primary btn-sm">
                            <?php echo getText('view_all'); ?> <?php echo getText('patients'); ?>
                        </a>
                    </div>
                <?php else: ?>
                    <div class="text-center text-muted">
                        <i class="fas fa-user-injured fa-3x mb-3"></i>
                        <p><?php echo getText('no_data_found'); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Upcoming Appointments -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-calendar-check me-2"></i>
                    <?php echo getText('upcoming_appointments') ?? 'المواعيد القادمة'; ?>
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($upcomingAppointments)): ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th><?php echo getText('patient'); ?></th>
                                    <th><?php echo getText('doctor'); ?></th>
                                    <th><?php echo getText('date'); ?></th>
                                    <th><?php echo getText('time'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($upcomingAppointments as $appointment): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($appointment['patient_name']); ?></td>
                                        <td><?php echo htmlspecialchars($appointment['doctor_name']); ?></td>
                                        <td><?php echo formatDate($appointment['appointment_date']); ?></td>
                                        <td><?php echo date('H:i', strtotime($appointment['appointment_time'])); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="text-center mt-3">
                        <a href="appointments.php" class="btn btn-primary btn-sm">
                            <?php echo getText('view_all'); ?> <?php echo getText('appointments'); ?>
                        </a>
                    </div>
                <?php else: ?>
                    <div class="text-center text-muted">
                        <i class="fas fa-calendar-alt fa-3x mb-3"></i>
                        <p><?php echo getText('no_appointments') ?? 'لا توجد مواعيد'; ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    <?php echo getText('quick_actions') ?? 'الإجراءات السريعة'; ?>
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="patients.php?action=add" class="btn btn-outline-primary w-100">
                            <i class="fas fa-user-plus d-block mb-2"></i>
                            <?php echo getText('add_patient'); ?>
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="staff.php?action=add" class="btn btn-outline-success w-100">
                            <i class="fas fa-user-tie d-block mb-2"></i>
                            <?php echo getText('add_staff'); ?>
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="appointments.php?action=add" class="btn btn-outline-info w-100">
                            <i class="fas fa-calendar-plus d-block mb-2"></i>
                            <?php echo getText('add_appointment'); ?>
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="procedures.php?action=add" class="btn btn-outline-warning w-100">
                            <i class="fas fa-procedures d-block mb-2"></i>
                            <?php echo getText('add_procedure'); ?>
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="invoices.php?action=add" class="btn btn-outline-secondary w-100">
                            <i class="fas fa-file-invoice d-block mb-2"></i>
                            <?php echo getText('create_invoice'); ?>
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                        <a href="reports.php" class="btn btn-outline-dark w-100">
                            <i class="fas fa-chart-bar d-block mb-2"></i>
                            <?php echo getText('reports'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>

