<?php
/**
 * لوحة التحكم الرئيسية
 * Main Dashboard
 */

require_once '../includes/functions.php';

// التحقق من تسجيل الدخول
if (!isLoggedIn()) {
    header('Location: ../index.php');
    exit;
}

// إعادة التوجيه حسب نوع المستخدم
$userType = $_SESSION['user_type'];
switch ($userType) {
    case 'admin':
        header('Location: admin/dashboard.php');
        break;
    case 'doctor':
        header('Location: doctor/dashboard.php');
        break;
    case 'receptionist':
        header('Location: receptionist/dashboard.php');
        break;
    default:
        // تسجيل خروج في حالة نوع مستخدم غير معروف
        logoutUser();
        header('Location: ../index.php?error=invalid_user_type');
}
exit;
?>

